#version 430 core

layout ( triangles ) in;
layout ( triangle_strip, max_vertices = 3) out;
 
 layout (location = 0) in vec4 geoPosition[];

 //outputs
layout (location = 0) out vec4 fragViewPos;
layout (location = 1) out smooth vec3 fragNormal;
layout (location = 2) out vec4 fragPosLightSpace;

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;

uniform mat4 projection;
uniform mat4 view;

vec3 calculateNormal(int location, mat4 MV){

	int primary;
	int secondary;
	int tertiary;

	if(location == 0){
		primary = 0;
		secondary = 1;
		tertiary = 2;
	}else if(location == 1){
		primary = 1;
		secondary = 2;
		tertiary = 0;
	}else if(location == 2){
		primary = 2;
		secondary = 0;
		tertiary = 1;
	}

	vec3 tangent = gl_in[secondary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 bitangent = gl_in[tertiary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 normal = cross(tangent, bitangent);	

	vec3 normalizedNormal = normalize(normal);

	mat3 normalMatrix = transpose(inverse(mat3(MV)));

	return normalize(normalMatrix * normalizedNormal);
}

void main(void){

	mat4 MVP;
	mat4 MV;
	mat4 lightSpaceModel;
		
	MVP[0] = vec4(imageLoad(inputTex, ivec2(0, 0)));
	MVP[1] = vec4(imageLoad(inputTex, ivec2(1, 0)));
	MVP[2] = vec4(imageLoad(inputTex, ivec2(2, 0)));
	MVP[3] = vec4(imageLoad(inputTex, ivec2(3, 0)));

	MV[0] = vec4(imageLoad(inputTex, ivec2(4, 0)));
	MV[1] = vec4(imageLoad(inputTex, ivec2(5, 0)));
	MV[2] = vec4(imageLoad(inputTex, ivec2(6, 0)));
	MV[3] = vec4(imageLoad(inputTex, ivec2(7, 0)));

	lightSpaceModel[0] = vec4(imageLoad(inputTex, ivec2(8, 0)));
	lightSpaceModel[1] = vec4(imageLoad(inputTex, ivec2(9, 0)));
	lightSpaceModel[2] = vec4(imageLoad(inputTex, ivec2(10, 0)));
	lightSpaceModel[3] = vec4(imageLoad(inputTex, ivec2(11, 0)));

	vec3 normal;

	vec4 viewPosition;

	viewPosition = MV * gl_in[0].gl_Position;
	gl_Position = MVP * gl_in[0].gl_Position;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(0, MV);
	fragPosLightSpace = lightSpaceModel * geoPosition[0];
	EmitVertex();

	viewPosition = MV * gl_in[1].gl_Position;
	gl_Position = MVP * gl_in[1].gl_Position;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(1, MV);
	fragPosLightSpace = lightSpaceModel * geoPosition[1];
	EmitVertex();

	viewPosition = MV * gl_in[2].gl_Position;
	gl_Position = MVP * gl_in[2].gl_Position;
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(2, MV);
	fragPosLightSpace = lightSpaceModel * geoPosition[2];
	EmitVertex();

	EndPrimitive();

}

